/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Random;

public class DrawPanel
extends Panel
implements Runnable {
    MyPanel parent;
    Random rand;
    int r;
    int g;
    int b;
    int r1;
    int g1;
    int b1;
    int x1;
    int y1;
    int x2;
    int y2;
    int bx;
    int by;
    final int R_DIRECTION = 3;
    final int G_DIRECTION = 5;
    final int B_DIRECTION = 4;
    final int X_DIRECTION = 5;
    final int Y_DIRECTION = 4;
    final int CIRCLE_COUNTER = 3;
    int DELAY = 3;
    double rotaryAngle = 1.0;
    double cosR = Math.cos(this.rotaryAngle);
    double sinR = Math.sin(this.rotaryAngle);
    double translateAngle;
    double cosT = Math.cos(this.translateAngle);
    double sinT = Math.sin(this.translateAngle);
    final int KEEP_COLOR = 0;
    final int LINE_COLOR_BOUNDS = 512;
    boolean isStop = false;
    int ballxDirection = 8;
    int ballyDirection = 6;
    int xsize;
    int ysize;
    int radius;
    int[] dstPixels;
    int[] srcPixels;
    double redFactor;
    double greenFactor;
    double blueFactor;
    Rectangle ball;
    Rectangle backBall;
    Point p1;
    Point p2;
    Thread drawer;
    Image backImage;
    Graphics backImageGc;
    Graphics mainGc;
    Runtime runtime = Runtime.getRuntime();
    FontMetrics fm;
    int xs = -1;
    int ys = -1;
    PixelGrabber pg;
    boolean isChangeBallLocation = true;
    int br;
    int bg;
    int bb;
    int br1;
    int bg1;
    int bb1;
    final int CIRCLE_COLOR_BOUNDS = (int)Math.round(76.5) * 2;

    DrawPanel(MyPanel myPanel) {
        this.parent = myPanel;
        this.rand = new Random();
        this.r = this.r1 = this.random(512);
        this.g = this.g1 = this.random(512);
        this.b = this.b1 = this.random(512);
        this.x1 = this.random(200);
        this.y1 = this.random(200);
        this.x2 = this.random(200);
        this.y2 = this.random(200);
        this.p1 = new Point(this.x1, this.y1);
        this.p2 = new Point(this.x2, this.y2);
        this.radius = 30;
        this.br = this.br1 = this.random(76);
        this.bg = this.bg1 = this.random(76);
        this.bb = this.bb1 = this.random(76);
        this.bx = this.random(200);
        this.by = this.random(200);
        this.ball = new Rectangle(this.bx, this.by, this.radius * 2, this.radius * 2);
        this.backBall = new Rectangle(this.radius * 2, this.radius * 2);
        this.addMouseListener(new MouseControler1());
        this.addMouseMotionListener(new MouseControler2());
    }

    int random(int n) {
        if (n == 0) {
            return 0;
        }
        return Math.abs(this.rand.nextInt()) % n;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public void paint(Graphics graphics) {
        this.start();
    }

    public void start() {
        this.drawer = new Thread(this);
        this.isStop = false;
        this.drawer.start();
    }

    public void stop() {
        this.isStop = true;
        this.drawer = null;
        this.mainGc.dispose();
        this.mainGc = null;
        this.backImageGc.dispose();
        this.backImageGc = null;
        this.srcPixels = null;
        this.dstPixels = null;
    }

    public void run() {
        long l = System.currentTimeMillis();
        this.xsize = this.getBounds().width;
        this.ysize = this.getBounds().height;
        if (this.backImage == null || this.backImage.getWidth(this) != this.xsize || this.backImage.getHeight(this) != this.ysize) {
            this.backImage = this.createImage(this.xsize, this.ysize);
            this.backImageGc = this.backImage.getGraphics();
            this.mainGc = this.getGraphics();
            this.backImageGc.setFont(new Font("", 0, 20));
            this.fm = this.backImageGc.getFontMetrics();
        }
        this.backImageGc.clearRect(0, 0, this.xsize, this.ysize);
        Image image = null;
        Image image2 = null;
        image = this.breateBall();
        image2 = this.createImage(new MemoryImageSource(this.backBall.width, this.backBall.height, this.srcPixels, 0, this.backBall.width));
        int n = 0;
        while (Thread.currentThread() == this.drawer && !this.isStop) {
            try {
                if (this.parent.isDrawLine) {
                    this.drawLine(this.backImageGc);
                }
                this.mainGc.drawImage(this.backImage, 0, 0, this.parent);
                l += (long)this.DELAY;
                if (this.parent.isDrawBall) {
                    if (n > 3) {
                        this.backImageGc.drawImage(image2, this.ball.x, this.ball.y, this.backBall.width, this.backBall.height, this.parent);
                        this.showString(this.backImageGc);
                        this.changeBallColor();
                        this.changeBallLocation();
                        image = this.breateBall();
                        image2 = this.createImage(new MemoryImageSource(this.backBall.width, this.backBall.height, this.srcPixels, 0, this.backBall.width));
                        this.backImageGc.drawImage(image, this.ball.x, this.ball.y, this.ball.width, this.ball.height, this.parent);
                        System.gc();
                        n = 0;
                    } else {
                        ++n;
                    }
                }
                Thread.sleep(Math.max(0L, l - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    void showString(Graphics graphics) {
        int n = 5;
        String string = " \u900f\u660e\u4e4b\u7403 ";
        String string2 = " width = " + this.xsize + ", height = " + this.ysize + " ";
        String string3 = " Free memory = ";
        if (this.xs < 0 || this.ys < 0) {
            this.xs = 30;
            this.ys = (this.ysize - this.fm.getHeight() * n) / 3;
        }
        graphics.setColor(Color.red);
        graphics.fill3DRect(this.xs, this.ys, this.fm.stringWidth(string), this.fm.getHeight(), true);
        graphics.setColor(Color.blue);
        graphics.drawString(string, this.xs, this.ys + this.fm.getAscent());
        graphics.setColor(Color.blue);
        graphics.fill3DRect(this.xs, this.ys + this.fm.getHeight() * 2, this.fm.stringWidth(string2), this.fm.getHeight(), false);
        graphics.setColor(Color.red);
        graphics.drawString(string2, this.xs, this.ys + this.fm.getAscent() + this.fm.getHeight() * 2);
        String string4 = String.valueOf(string3) + this.runtime.freeMemory() + " ";
        graphics.setColor(Color.green);
        graphics.fill3DRect(this.xs, this.ys + this.fm.getHeight() * 4, this.fm.stringWidth(string3) * 2, this.fm.getHeight(), false);
        graphics.setColor(Color.black);
        graphics.drawString(string4, this.xs, this.ys + this.fm.getAscent() + this.fm.getHeight() * 4);
    }

    Image breateBall() {
        this.backBall.setBounds(this.ball.x, this.ball.y, this.ball.width, this.ball.height);
        if (this.srcPixels == null || this.srcPixels.length < this.ball.width * this.ball.height) {
            this.srcPixels = new int[this.backBall.width * this.backBall.height];
            this.dstPixels = new int[this.ball.width * this.ball.height];
        }
        this.pg = new PixelGrabber(this.backImage, this.backBall.x, this.backBall.y, this.backBall.width, this.backBall.height, this.srcPixels, 0, this.backBall.width);
        try {
            this.pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Error error) {}
        int n = this.radius;
        int n2 = this.radius;
        int n3 = 0;
        int n4 = this.radius * this.radius;
        int n5 = 0;
        while (n5 < this.ball.height) {
            int n6 = 0;
            while (n6 < this.ball.width) {
                double d = n6 - n;
                double d2 = n2 - n5;
                int n7 = (int)(d * d + d2 * d2);
                if (n7 < n4) {
                    double d3 = Math.sqrt(n7);
                    double d4 = d3 / (double)this.radius;
                    int n8 = n + (int)Math.round(d * d4);
                    int n9 = n2 - (int)Math.round(d2 * d4);
                    if (n8 < this.ball.width && n9 < this.ball.height && n8 >= 0 && n9 >= 0) {
                        int n10;
                        double d5 = ((double)this.radius - d3) / (double)this.radius;
                        double d6 = d5 * this.redFactor + (1.0 - this.redFactor);
                        double d7 = d5 * this.greenFactor + (1.0 - this.greenFactor);
                        double d8 = d5 * this.blueFactor + (1.0 - this.blueFactor);
                        int n11 = this.srcPixels[n8 + n9 * this.ball.width];
                        this.dstPixels[n3] = n10 = ((n11 >> 24 & 0xFF) << 24) + ((int)Math.round((double)(n11 >> 16 & 0xFF) * d6) << 16) + ((int)Math.round((double)(n11 >> 8 & 0xFF) * d7) << 8) + (int)Math.round((double)(n11 & 0xFF) * d8);
                    } else {
                        this.dstPixels[n3] = this.srcPixels[n3];
                    }
                } else {
                    this.dstPixels[n3] = this.srcPixels[n3];
                }
                ++n6;
                ++n3;
            }
            ++n5;
        }
        return this.createImage(new MemoryImageSource(this.ball.width, this.ball.height, this.dstPixels, 0, this.ball.width));
    }

    void changeBallLocation() {
        int n;
        int n2;
        int n3 = (this.xsize - this.ball.width) * 2;
        int n4 = (this.ysize - this.ball.height) * 2;
        if (this.isChangeBallLocation) {
            n2 = this.ballxDirection;
            n = this.ballyDirection;
        } else {
            n2 = 0;
            n = 0;
        }
        this.bx += (int)Math.abs(Math.round(this.cosT * 2.0 * (double)n2));
        this.by += (int)Math.round(this.sinT * 2.0 * (double)n);
        this.bx = (this.bx + this.random(n2) + n3) % n3;
        this.ball.x = this.bx >= n3 / 2 ? n3 - 1 - this.bx : this.bx;
        this.by = (this.by + this.random(n) + n4) % n4;
        if (this.by >= n4 / 2) {
            this.ball.y = n4 - 1 - this.by;
            return;
        }
        this.ball.y = this.by;
    }

    public void drawLine(Graphics graphics) {
        this.changeLineColor();
        graphics.setColor(new Color(this.r, this.g, this.b));
        this.changeLineLocation();
        graphics.drawLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
    }

    void setAngle(double d) {
        this.rotaryAngle = d <= 5.0 || d <= 4.0 ? 0.3490658503988659 : Math.min(Math.acos(4.0 / d), Math.asin(5.0 / d));
        this.cosR = Math.cos(this.rotaryAngle);
        this.sinR = Math.sin(this.rotaryAngle);
        this.translateAngle += 0.17453292519943295;
        this.translateAngle = Math.IEEEremainder(this.translateAngle, Math.PI * 2);
        this.cosT = Math.cos(this.translateAngle);
        this.sinT = Math.sin(this.translateAngle);
    }

    void changeLineLocation() {
        int n = this.xsize * 2;
        int n2 = this.ysize * 2;
        int n3 = this.x2 - this.x1;
        int n4 = this.y2 - this.y1;
        double d = Math.sqrt(n3 * n3 + n4 * n4);
        this.setAngle(d);
        int n5 = this.x1 + n3 / 2;
        int n6 = this.y1 + n4 / 2;
        int n7 = (int)((double)Math.round(this.x1 - n5) * this.cosR - (double)(this.y1 - n6) * this.sinR + (double)n5);
        int n8 = (int)((double)Math.round(this.y1 - n6) * this.cosR + (double)(this.x1 - n5) * this.sinR + (double)n6);
        this.x1 = n7;
        this.y1 = n8;
        n7 = (int)((double)Math.round(this.x2 - n5) * this.cosR - (double)(this.y2 - n6) * this.sinR + (double)n5);
        n8 = (int)((double)Math.round(this.y2 - n6) * this.cosR + (double)(this.x2 - n5) * this.sinR + (double)n6);
        this.x2 = n7;
        this.y2 = n8;
        this.x1 = (this.x1 + this.random(5) + n) % n;
        this.p1.x = this.x1 >= n / 2 ? n - 1 - this.x1 : this.x1;
        this.x2 = (this.x2 + this.random(5) + n) % n;
        this.p2.x = this.x2 >= n / 2 ? n - 1 - this.x2 : this.x2;
        this.y1 = (this.y1 + this.random(4) + n2) % n2;
        this.p1.y = this.y1 >= n2 / 2 ? n2 - 1 - this.y1 : this.y1;
        this.y2 = (this.y2 + this.random(4) + n2) % n2;
        if (this.y2 >= n2 / 2) {
            this.p2.y = n2 - 1 - this.y2;
            return;
        }
        this.p2.y = this.y2;
    }

    void changeLineColor() {
        this.r1 = (this.r1 + this.random(3)) % 512;
        this.r = this.r1 >= 256 ? 511 - this.r1 : this.r1;
        this.g1 = (this.g1 + this.random(5)) % 512;
        this.g = this.g1 >= 256 ? 511 - this.g1 : this.g1;
        this.b1 = (this.b1 + this.random(4)) % 512;
        if (this.b1 >= 256) {
            this.b = 511 - this.b1;
            return;
        }
        this.b = this.b1;
    }

    void changeBallColor() {
        this.br1 = (this.br1 + this.random(3)) % this.CIRCLE_COLOR_BOUNDS;
        this.br = this.br1 >= this.CIRCLE_COLOR_BOUNDS / 2 ? this.CIRCLE_COLOR_BOUNDS - 1 - this.br1 : this.br1;
        this.redFactor = (double)this.br / 255.0;
        this.bg1 = (this.bg1 + this.random(5)) % this.CIRCLE_COLOR_BOUNDS;
        this.bg = this.bg1 >= this.CIRCLE_COLOR_BOUNDS / 2 ? this.CIRCLE_COLOR_BOUNDS - 1 - this.bg1 : this.bg1;
        this.greenFactor = (double)this.bg / 255.0;
        this.bb1 = (this.bb1 + this.random(4)) % this.CIRCLE_COLOR_BOUNDS;
        this.bb = this.bb1 >= this.CIRCLE_COLOR_BOUNDS / 2 ? this.CIRCLE_COLOR_BOUNDS - 1 - this.bb1 : this.bb1;
        this.blueFactor = (double)this.bb / 255.0;
    }

    class MouseControler1
    extends MouseAdapter {
        public void mouseExited(MouseEvent mouseEvent) {
            if (DrawPanel.this.parent.isDrawBall) {
                DrawPanel.this.isChangeBallLocation = true;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (DrawPanel.this.parent.isDrawBall) {
                DrawPanel.this.isChangeBallLocation = false;
            }
        }

        MouseControler1() {
            DrawPanel.this = DrawPanel.this;
        }
    }

    class MouseControler2
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent mouseEvent) {
            if (DrawPanel.this.parent.isDrawBall) {
                DrawPanel.this.bx = mouseEvent.getX() - DrawPanel.this.ball.width / 2;
                DrawPanel.this.by = mouseEvent.getY() - DrawPanel.this.ball.height;
            }
        }

        MouseControler2() {
            DrawPanel.this = DrawPanel.this;
        }
    }
}

